/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.fakeworld;

import com.mojang.datafixers.util.Pair;
import dev.compactmods.crafting.client.fakeworld.RecipeChunk;
import dev.compactmods.crafting.client.fakeworld.RenderingWorld;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class RenderingChunkProvider
extends ChunkSource {
    private final Holder<Biome> VOID = (Holder)ForgeRegistries.BIOMES.getHolder(Biomes.f_48173_).get();
    private final MiniaturizationRecipe recipe;
    private final Map<ChunkPos, ChunkAccess> chunks;
    private final RenderingWorld renderingLevel;
    private final LevelLightEngine lightManager;

    public RenderingChunkProvider(RenderingWorld renderingLevel, MiniaturizationRecipe recipe) {
        this.recipe = recipe;
        this.renderingLevel = renderingLevel;
        this.lightManager = new LevelLightEngine((LightChunkGetter)this, true, true);
        HashMap byChunk = new HashMap();
        BlockPos.m_121921_((AABB)this.recipe.getDimensions()).map(BlockPos::m_7949_).forEach(pos -> byChunk.computeIfAbsent(new ChunkPos(pos), $ -> new ArrayList()).add(pos));
        this.chunks = byChunk.keySet().stream().map(chunkPos -> Pair.of((Object)chunkPos, (Object)((Object)new RecipeChunk(this.renderingLevel, (ChunkPos)chunkPos, recipe)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Nullable
    public ChunkAccess m_7587_(int cx, int cz, ChunkStatus status, boolean load) {
        return this.chunks.computeIfAbsent(new ChunkPos(cx, cz), p -> new EmptyLevelChunk((Level)this.renderingLevel, p, this.VOID));
    }

    public void m_201698_(BooleanSupplier bool, boolean bool2) {
    }

    public String m_6754_() {
        return "?";
    }

    public int m_142061_() {
        return this.chunks.size();
    }

    public LevelLightEngine m_7827_() {
        return this.lightManager;
    }

    public BlockGetter m_7653_() {
        return this.renderingLevel;
    }
}

